--[[---------------------------------------------------------------------------
	Chocolatier Two Development Toolbar
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-- devAlpha = .7
devBackgroundColor = Color(144,27,27,192)
devTextColor = WhiteColor
devfont = { simpleFontName, 13, devTextColor }
devPopupFont = { simpleFontName, 13, BlackColor }

-------------------------------------------------------------------------------

function DevMenu(t)
	local m = t
	return function()
		table.insert(m, TightText { x=0,y=0,w=ui.devScreenWidth,h=ui.devScreenHeight, flags=kVAlignTop+kHAlignLeft, font=m.font or devfont, label=m.label, name=m.name })
		if type(m.dscript) == "string" then m.command = function() DisplayDialog { m.dscript, x=m.x, y=bsgFontHeight(devfont) } end end
		if m.fit == nil then m.fit = true end
		m.name = nil
		m.graphics = {}
		m.typename='Button'
		DoWindow(m)
	end
end

function DevMenuItem(t) return DevMenu(t) end

-------------------------------------------------------------------------------

function DevUpdateCurrent()
	local label = "no quest"
	if gSim.quest then label = GetString(gSim.quest.name) end
	bsgSetGlobalLabel("dev_current", label)
end

local function CurrentMenu(t)
	local m = t
	return function()
		local label = m.label or "#no quest"
		if gSim.quest then label = "#"..GetString(gSim.quest.name) end
		table.insert(m, Text { x=0,y=0,w=150,h=bsgFontHeight(devfont), flags=kVAlignTop+kHAlignLeft, font=devfont, label=label, name="dev_current" })
		m.command = function()
			if gSim.quest then DisplayDialog { "dev/devcurrent.lua", x=m.x, y=bsgFontHeight(devfont) } end
		end
		
		if m.fit == nil then m.fit = true end
		m.name = nil
		m.graphics = {}
		m.typename='Button'
		DoWindow(m)
	end
end

-------------------------------------------------------------------------------

MakeDialog
{
	name="dev",
	AppendStyle { font=devfont },
	Rectangle
	{
		x=0,y=0, w=ui.devScreenWidth,h=bsgFontHeight(devfont), color=devBackgroundColor, fit=true,
		
		DevMenu { x=5,y=0, label="#Quests", dscript="dev/devquests.lua" },
		CurrentMenu { x=55,y=0, },
		DevMenu { x=200,y=0, label="#Products", dscript="dev/devproducts.lua" },
		DevMenu { x=260,y=0, label="#Ingredients", dscript="dev/devingredients.lua" },
		DevMenu { x=335,y=0, label="#Ports", dscript="dev/devports.lua" },
		DevMenu { x=370,y=0, label="#Buildings", dscript="dev/devbuildings.lua" },
		DevMenu { x=430,y=0, label="#Misc", dscript="dev/devmisc.lua" },
		DevMenu { x=ui.devScreenWidth-75,y=0, label="#Money", dscript="dev/devmoney.lua" },
	}
}
